# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdtypevector import SDTypeVector
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDTypeFloat2(SDTypeVector):
    """
    Class representing the float2 type
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDTypeFloat2
        """
        super(SDTypeFloat2, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew() -> SDTypeFloat2:
        """
        Create new SDTypeFloat2

        """
        outSDTypeFloat2 = ctypes.c_void_p()
        _res = sd.getContext().SDTypeFloat2_sNew(ctypes.byref(outSDTypeFloat2))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDTypeFloat2, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDTypeFloat2.value, ownHandle=True)

